// author: RuanShengQiang 
// date: 2017/6/1
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float _abs(float a)
{
	if(a<0.0f)
		return -a;
	else
		return a;
}

bool inBounds (vec2 p) {
	vec2 boundMin = (vec2)(0.0f, 0.0f);
	vec2 boundMax = (vec2)(1.0f, 1.0f);
	return boundMin.x<p.x && boundMin.y<p.y && p.x < boundMax.x && p.y <boundMax.y;
}

vec2 project (vec2 p) {
  return p * (vec2)(1.0f, -1.2f) + (vec2)(0.0f, -0.02f);
}

vec4 bgColor (vec2 p, vec2 pfr, vec2 pto, image2d_t input1,image2d_t input2,__global FilterParam* param ) {
  vec4 black = (vec4)(0.0f, 0.0f, 0.0f, 1.0f);
  float reflection = 0.4f;
  vec4 c = black;
  pfr = project(pfr);
  if (inBounds(pfr)) {
    c += mix(black, INPUT(input1, param, pfr), reflection * mix(1.0f, 0.0f, pfr.y));
	if(pfr.y <= 0.01f)
    {
      float a = smoothstep(0.f, 0.01f, pfr.y);
	  c = mix((vec4)((vec3)(0.0f), 1.0f), c, a);
    }
  }
  pto = project(pto);
  if (inBounds(pto)) {
    c += mix(black, INPUT(input2, param,pto), reflection * mix(1.0f, 0.0f, pto.y));
	if(pto.y <= 0.01f)
    {
      float a = smoothstep(0.f, 0.01f, pto.y);
	  c = mix((vec4)((vec3)(0.0f), 1.0f), c, a);
    }
  }
  return c;
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	
	float perspective = 0.2f;
	float depth = 3.0f;
	vec2 pfr, pto = (vec2)(-1.f);
 
	float size = mix(1.0f, depth, progress);
	float persp = perspective * progress;
	  pfr = (p + (vec2)(-0.0f, -0.5f)) * (vec2)(size/(1.0f-perspective*progress), size/(1.0f-size*persp*p.x)) + (vec2)(0.0f, 0.5f);
	 
	  size = mix(1.0f, depth, 1.f-progress);
	  persp = perspective * (1.f-progress);
	  pto = (p + (vec2)(-1.0f, -0.5f)) * (vec2)(size/(1.0f-perspective*(1.0f-progress)), size/(1.0f-size*persp*(0.5f-p.x))) + (vec2)(1.0f, 0.5f);
	 
	  bool fromOver = progress < 0.5f;
	 float4 gl_FragColor;
	 float a = 1.0f;
  if (fromOver) {
    if (inBounds(pfr)) {
	  if (pfr.y >= 0.99f)
	  {
        a = 1.0f - smoothstep(0.99f, 1.0f, pfr.y);
      }
      else if(pfr.y <= 0.01f)
      {
        a = smoothstep(0.f, 0.01f, pfr.y);
      }
      gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input1, param, pfr), a);
    }
    else if (inBounds(pto)) {
	  if (pto.y >= 0.99f)
	  {
        a = 1.0f - smoothstep(0.99f, 1.0f, pto.y);
      }
      else if(pto.y <= 0.01f)
      {
        a = smoothstep(0.f, 0.01f, pto.y);
      }
      gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input2, param, pto), a);
    }
    else {
      gl_FragColor = bgColor(p, pfr, pto,input1,input2, param);
    }
  }
  else {
    if (inBounds(pto)) {
      if (pto.y >= 0.99f)
	  {
        a = 1.0f - smoothstep(0.99f, 1.0f, pto.y);
      }
      else if(pto.y <= 0.01f)
      {
        a = smoothstep(0.f, 0.01f, pto.y);
      }
      gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input2, param,pto), a);
    }
    else if (inBounds(pfr)) {
      if (pfr.y >= 0.99f)
	  {
        a = 1.0f - smoothstep(0.99f, 1.0f, pfr.y);
      }
      else if(pfr.y <= 0.01f)
      {
        a = smoothstep(0.f, 0.01f, pfr.y);
      }
      gl_FragColor = mix((vec4)((vec3)(0.0f), 1.0f), INPUT(input1, param, pfr), a);
    }
    else {
      gl_FragColor = bgColor(p, pfr, pto,input1,input2, param);
    }
  }
	write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}